<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Operation extends Model 
{

    protected $table = 'operations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function site()
    {
        return $this->belongsTo('Site');
    }

    public function implantation()
    {
        return $this->belongsTo('Implantation');
    }

    public function nature()
    {
        return $this->belongsTo('Nature');
    }

    public function support()
    {
        return $this->belongsTo('Support');
    }

    public function type()
    {
        return $this->belongsTo('Type');
    }

    public function production_status()
    {
        return $this->belongsTo('ProductionStatus');
    }

}